#include <inc/nini.hpp>

Nini::Nini(void) {

  x = 0.0;
  y = 0.0;

  move_speed = 1.0;

  ticks = 0;
  frame = 0;

  reset = true;

  meowing = false;

  is_moving = false;

  moving[0] = false;
  moving[1] = false;
  moving[2] = false;
  moving[3] = false;

  facing_direction[0] = false;
  facing_direction[1] = false;

  bitmap = NULL;

  meow_sample = NULL;
}

bool Nini::loadBitmap(void) {

  bitmap = al_load_bitmap("png/nini.png");

  meow_sample = al_load_sample("ogg/meow.ogg");

  return (bitmap && meow_sample);
}

float Nini::getX(void) {

  return x;
}

float Nini::getY(void) {

  return y;
}

void Nini::move(const bool keys[4]) {

  if (!is_moving) {

    if (keys[0]) {

      // Attempt to move up.

      if (TileMap->getTiles()[(x / 16)][(y / 16) - 1].substr(5, 6) != "S") {

        is_moving = true;

        moving[0] = true;
        moving[1] = false;
        moving[2] = false;
        moving[3] = false;
      }
    }
    else if (keys[1]) {

      // Attempt to move down.

      if (TileMap->getTiles()[(x / 16)][(y / 16) + 1].substr(5, 6) != "S") {

        is_moving = true;

        moving[0] = false;
        moving[1] = true;
        moving[2] = false;
        moving[3] = false;
      }
    }
    else if (keys[2]) {

      // Attempt to move left.

      setFacingDirection(0);

      if (TileMap->getTiles()[(x / 16) - 1][(y / 16)].substr(5, 6) != "S") {

        is_moving = true;

        moving[0] = false;
        moving[1] = false;
        moving[2] = true;
        moving[3] = false;
      }
    }
    else if (keys[3]) {

      // Attempt to move right.

      setFacingDirection(1);

      if (TileMap->getTiles()[(x / 16) + 1][(y / 16)].substr(5, 6) != "S") {

        is_moving = true;

        moving[0] = false;
        moving[1] = false;
        moving[2] = false;
        moving[3] = true;
      }
    }
  }
}

void Nini::spawn(void) {

  // Pick a random spot to spawn Nini.
  unsigned int spawn_x = RNG->getNumber() % TileMap->getTiles().size();
  unsigned int spawn_y = RNG->getNumber() % TileMap->getTiles()[0].size();

  while (TileMap->getTiles()[spawn_x][spawn_y].substr(5, 6) != "C") {

    // Nini spawned in non-designated tile. Try again.
    spawn_x = RNG->getNumber() % TileMap->getTiles().size();
    spawn_y = RNG->getNumber() % TileMap->getTiles()[0].size();
  }

  x = spawn_x * 16;
  y = spawn_y * 16;

  // Remove spawn marker.
  TileMap->getTiles()[spawn_x][spawn_y] = "00x00L";

  setFacingDirection(RNG->getNumber() % 2);
}

void Nini::update(void) {

  if (moving[0]) {

    moveUp();
  }
  else if (moving[1]) {

    moveDown();
  }
  else if (moving[2]) {

    moveLeft();
  }
  else if (moving[3]) {

    moveRight();
  }

  if (is_moving) {

    // Update animation.

    ++ticks;

    if (ticks > 8) {

      ticks = 0;

      ++frame;

      if (frame > 1) {

        frame = 0;
      }
    }
  }
}

void Nini::render(const float cam_x, const float cam_y) {

  unsigned int facing = 0;

  for (unsigned int i = 0; i < 2; ++i) {

    if (facing_direction[i]) {

      facing = i;
    }
  }

  if (meowing) {

    static unsigned int frames = 0;

    ++frames;

    if (frames == 10) {

      frames = 0;

      meowing = false;
    }

    al_draw_bitmap_region(bitmap, 16 * facing, 16 * frame, 16, 16, x - cam_x, y - cam_y, 0);

    // Draw Nini red for a short time.
    al_draw_tinted_bitmap_region(bitmap, al_map_rgba(0, 0, 0, 128), 16 * facing, 16 * frame, 16, 16, x - cam_x, y - cam_y, 0);
  }
  else {

    al_draw_bitmap_region(bitmap, 16 * facing, 16 * frame, 16, 16, x - cam_x, y - cam_y, 0);
  }
}

void Nini::moveUp(void) {

  if (reset) {

    start_tile = y / 16;

    stop_tile = start_tile - 1;

    TileMap->getTiles()[x / 16][stop_tile] = TileMap->getTiles()[x / 16][stop_tile].substr(0, 5) + string("S");
    TileMap->getTiles()[x / 16][start_tile] = TileMap->getTiles()[x / 16][start_tile].substr(0, 5) + string("S");

    reset = false;
  }

  if (y / 16 > stop_tile) {

    y -= move_speed;
  }
  else {

    TileMap->getTiles()[x / 16][start_tile] = TileMap->getTiles()[x / 16][start_tile].substr(0, 5) + string("L");

    reset = true;

    is_moving = false;

    moving[0] = false;
    moving[1] = false;
    moving[2] = false;
    moving[3] = false;
  }
}

void Nini::moveDown(void) {

  if (reset) {

    start_tile = y / 16;

    stop_tile = start_tile + 1;

    TileMap->getTiles()[x / 16][stop_tile] = TileMap->getTiles()[x / 16][stop_tile].substr(0, 5) + string("S");
    TileMap->getTiles()[x / 16][start_tile] = TileMap->getTiles()[x / 16][start_tile].substr(0, 5) + string("S");

    reset = false;
  }

  if (y / 16 < stop_tile) {

    y += move_speed;
  }
  else {

    TileMap->getTiles()[x / 16][start_tile] = TileMap->getTiles()[x / 16][start_tile].substr(0, 5) + string("L");

    reset = true;

    is_moving = false;

    moving[0] = false;
    moving[1] = false;
    moving[2] = false;
    moving[3] = false;
  }
}

void Nini::moveLeft(void) {

  if (reset) {

    start_tile = x / 16;

    stop_tile = start_tile - 1;

    TileMap->getTiles()[stop_tile][y / 16] = TileMap->getTiles()[stop_tile][y / 16].substr(0, 5) + string("S");
    TileMap->getTiles()[stop_tile][y / 16] = TileMap->getTiles()[stop_tile][y / 16].substr(0, 5) + string("S");

    reset = false;
  }

  if (x / 16 > stop_tile) {

    x -= move_speed;
  }
  else {

    TileMap->getTiles()[start_tile][y / 16] = TileMap->getTiles()[start_tile][y / 16].substr(0, 5) + string("L");

    reset = true;

    is_moving = false;

    moving[2] = false;
  }
}

void Nini::moveRight(void) {

  if (reset) {

    start_tile = x / 16;

    stop_tile = start_tile + 1;

    TileMap->getTiles()[stop_tile][y / 16] = TileMap->getTiles()[stop_tile][y / 16].substr(0, 5) + string("S");
    TileMap->getTiles()[stop_tile][y / 16] = TileMap->getTiles()[stop_tile][y / 16].substr(0, 5) + string("S");

    reset = false;
  }

  if (x / 16 < stop_tile) {

    x += move_speed;
  }
  else {

    TileMap->getTiles()[start_tile][y / 16] = TileMap->getTiles()[start_tile][y / 16].substr(0, 5) + string("L");

    reset = true;

    is_moving = false;

    moving[0] = false;
    moving[1] = false;
    moving[2] = false;
    moving[3] = false;
  }
}

void Nini::setObjects(Map *M, Random *R) {

  RNG = R;
  TileMap = M;
}

void Nini::destroyBitmap(void) {

  al_destroy_bitmap(bitmap);

  al_destroy_sample(meow_sample);
}

void Nini::setFacingDirection(const unsigned int direction) {

  facing_direction[0] = false;
  facing_direction[1] = false;

  facing_direction[direction] = true;
}

void Nini::meow(void) {

  meowing = true;

  al_play_sample(meow_sample, 1.0, 0.0, 1.0, ALLEGRO_PLAYMODE_ONCE, 0);
}
